#ifndef VersionManager_h__
#define VersionManager_h__

#include <boost/shared_ptr.hpp>
#include <buildspec.h>

namespace GST
{
namespace ClientUtils
{
class NetworkInterface;

class GST_API_EXPORT VersionManager
{
public:
	/**
	checks the compatibility of the client and storage versions

	@returns
	- a negative number, if client is to old for the installed storage version
	- zero, if client and storage are compatible
	- a positive number, if client is the new for the installed storage
	version*/
	static int checkCompatibility(const NetworkInterface *ni);

private:
	VersionManager()
	{
	}
};

} // namespace ClientUtils
} // namespace GST
#endif // VersionManager_h__
